define([
    'backbone',
    'Layout',
    'backgrid',
    'backgrid-paginator',
    'modules/appointments/booked/booked-appointments-view',
    'modules/appointments/booked/pagination/booked-appointments-top-pagination-view',
    'spec_helpers/custom-matchers',
], function(Backbone, Layout, Backgrid, BackgridPaginator,
    BookedAppointmentsView, BookedAppointmentsTopPanelPagination, customMatchers) {
    'use strict';

    describe('Pagination Panels', function() {
        var view;
        var $view;
        var layout = new Layout();
        var appointmentList = new Backbone.Collection([
            {
                'startDate': '2018-09-04T20:00:00Z',
                'clinicId': '32',
                'facilityId': '523',
                'patientIcn': '1006088937V099668',
                'vdsAppointments': [
                    {
                        'appointmentLength': '60',
                        'appointmentTime': '2018-09-04T20:00:00Z',
                        'clinic': {
                            'name': 'PRIMARY CARE',
                            'askForCheckIn': false,
                            'facilityCode': '523',
                        },
                        'patientId': '101076',
                        'type': 'COMPENSATION & PENSION',
                        'currentStatus': 'FUTURE',
                        'bookingNote': 'This appointment was booked from a Veteran Request.',
                    },
                ],
            }, {
                'startDate': '2018-09-05T14:30:00Z',
                'clinicId': '32',
                'facilityId': '523',
                'patientIcn': '1006088937V099668',
                'vdsAppointments': [
                    {
                        'appointmentLength': '30',
                        'appointmentTime': '2018-09-05T14:30:00Z',
                        'clinic': {
                            'name': 'PRIMARY CARE',
                            'askForCheckIn': false,
                            'facilityCode': '523',
                        },
                        'patientId': '101076',
                        'type': 'REGULAR',
                        'currentStatus': 'FUTURE',
                    },
                ],
            },
        ]);
        var topPanelExpectedHtml = '<div class="backgrid-paginator"><span>' +
            '<span aria-label="2 found, displaying 1 through 2" tabindex="0">2 found, displaying 1 through 2</span>' +
            '<br></span></div>'.trim();

        var bottomPanelExpectedHtml = '<div class="backgrid-paginator"><span><span aria-label="2 found, displaying 1 through 2" ' +
            'tabindex="0">2 found, displaying 1 through 2</span><br>' +
            '<ul>' +
            '<li class="disabled"><a href="javascript:void(0);" title="First" aria-label="Display first Page of appointments (Disabled)" tabindex="0">《</a></li>' +
            '<li class="disabled"><a href="javascript:void(0);" title="Previous" tabindex="0" aria-label="Display previous appointments (Disabled)">〈</a></li>' +
            '<li class="disabled"><a href="javascript:void(0);" title="Page 1" aria-label="Page 1, showing appointments 1 through 2 (Disabled)" tabindex="0">1</a></li>' +
            '<li class="disabled"><a href="javascript:void(0);" title="Next" tabindex="0" aria-label="Display next appointments (Disabled)">〉</a></li>' +
            '<li class="disabled"><a href="javascript:void(0);" title="Last" aria-label="Display last page of appointments (Disabled)" tabindex="0">》</a></li>' +
            '</ul></span></div>';
        bottomPanelExpectedHtml = bottomPanelExpectedHtml.trim();

        layout.render();

        beforeEach(function() {
            jasmine.addMatchers(customMatchers);
            view = new BookedAppointmentsView({ collection: appointmentList});
            layout.showChildView('content', view);
            $view = view.$el;
        });

        it('has top and bottom pagination panels', function() {

            expect($view.has(view.regions.paginationControlTopRegion).length).toEqual(1);
            expect($view.has(view.regions.paginationControlBottomRegion).length).toEqual(1);

            // top panel has only the page text..
            expect($view.find('#top-paginator').length).toEqual(1);
            expect($view.find('#top-paginator')[0].innerHTML.trim()).toEqual(topPanelExpectedHtml.trim());


            expect($view.find('#bottom-paginator-div').length).toEqual(1);
            expect(($view.find('#bottom-paginator-div')[0].innerHTML).trim()).toEqual(bottomPanelExpectedHtml.trim());

        });
    });

    describe('Pagination Panel for no appointments', function() {
        var view;
        var $view;
        var layout = new Layout();
        var appointmentList = new Backbone.Collection([]);
        var topPanelExpectedHtml = '';
        var bottomPanelExpectedHtml = '\n\n';


        layout.render();

        beforeEach(function() {
            jasmine.addMatchers(customMatchers);


            view = new BookedAppointmentsView({ collection: appointmentList});
            layout.showChildView('content', view);
            $view = view.$el;

        });

        it('has no top and bottom panels', function() {


            expect($view.find('#top-paginator').length).toEqual(1);
            expect($view.find('#top-paginator')[0].innerHTML).toEqual(topPanelExpectedHtml);

            expect($view.find('#bottom-paginator-div').length).toEqual(1);
            expect($view.find('#bottom-paginator-div')[0].innerHTML).toEqual(bottomPanelExpectedHtml);


        });
    });

    describe('Pagination Panels for more than one page data', function() {
        var view;
        var $view;
        var layout = new Layout();
        var appointmentList = new Backbone.Collection([
            {
                'startDate': '2018-09-04T20:00:00Z',
                'clinicId': '32',
                'facilityId': '523',
                'patientIcn': '1006088937V099668',
                'vdsAppointments': [
                    {
                        'appointmentLength': '60',
                        'appointmentTime': '2018-09-04T20:00:00Z',
                        'clinic': {
                            'name': 'PRIMARY CARE',
                            'askForCheckIn': false,
                            'facilityCode': '523',
                        },
                        'patientId': '101076',
                        'type': 'COMPENSATION & PENSION',
                        'currentStatus': 'FUTURE',
                        'bookingNote': 'This appointment was booked from a Veteran Request.',
                    },
                ],
            }, {
                'startDate': '2018-09-05T14:30:00Z',
                'clinicId': '32',
                'facilityId': '523',
                'patientIcn': '1006088937V099668',
                'vdsAppointments': [
                    {
                        'appointmentLength': '30',
                        'appointmentTime': '2018-09-05T14:30:00Z',
                        'clinic': {
                            'name': 'PRIMARY CARE',
                            'askForCheckIn': false,
                            'facilityCode': '523',
                        },
                        'patientId': '101076',
                        'type': 'REGULAR',
                        'currentStatus': 'FUTURE',
                    },
                ],
            },
            {
                'startDate': '2018-09-06T14:30:00Z',
                'clinicId': '32',
                'facilityId': '523',
                'patientIcn': '1006088937V099668',
                'vdsAppointments': [
                    {
                        'appointmentLength': '30',
                        'appointmentTime': '2018-09-06T14:30:00Z',
                        'clinic': {
                            'name': 'PRIMARY CARE',
                            'askForCheckIn': false,
                            'facilityCode': '523',
                        },
                        'patientId': '101076',
                        'type': 'REGULAR',
                        'currentStatus': 'FUTURE',
                    },
                ],
            },
            {
                'startDate': '2018-09-07T14:30:00Z',
                'clinicId': '32',
                'facilityId': '523',
                'patientIcn': '1006088937V099668',
                'vdsAppointments': [
                    {
                        'appointmentLength': '30',
                        'appointmentTime': '2018-09-07T14:30:00Z',
                        'clinic': {
                            'name': 'PRIMARY CARE',
                            'askForCheckIn': false,
                            'facilityCode': '523',
                        },
                        'patientId': '101076',
                        'type': 'REGULAR',
                        'currentStatus': 'FUTURE',
                    },
                ],
            },
            {
                'startDate': '2018-09-08T14:30:00Z',
                'clinicId': '32',
                'facilityId': '523',
                'patientIcn': '1006088937V099668',
                'vdsAppointments': [
                    {
                        'appointmentLength': '30',
                        'appointmentTime': '2018-09-08T14:30:00Z',
                        'clinic': {
                            'name': 'PRIMARY CARE',
                            'askForCheckIn': false,
                            'facilityCode': '523',
                        },
                        'patientId': '101076',
                        'type': 'REGULAR',
                        'currentStatus': 'FUTURE',
                    },
                ],
            },
            {
                'startDate': '2018-09-09T14:30:00Z',
                'clinicId': '32',
                'facilityId': '523',
                'patientIcn': '1006088937V099668',
                'vdsAppointments': [
                    {
                        'appointmentLength': '30',
                        'appointmentTime': '2018-09-09T14:30:00Z',
                        'clinic': {
                            'name': 'PRIMARY CARE',
                            'askForCheckIn': false,
                            'facilityCode': '523',
                        },
                        'patientId': '101076',
                        'type': 'REGULAR',
                        'currentStatus': 'FUTURE',
                    },
                ],
            },
            {
                'startDate': '2018-09-10T14:30:00Z',
                'clinicId': '32',
                'facilityId': '523',
                'patientIcn': '1006088937V099668',
                'vdsAppointments': [
                    {
                        'appointmentLength': '30',
                        'appointmentTime': '2018-09-10T14:30:00Z',
                        'clinic': {
                            'name': 'PRIMARY CARE',
                            'askForCheckIn': false,
                            'facilityCode': '523',
                        },
                        'patientId': '101076',
                        'type': 'REGULAR',
                        'currentStatus': 'FUTURE',
                    },
                ],
            },
        ]);
        var topPanelExpectedHtml = '<div class="backgrid-paginator"><span>' +
            '<span aria-label="7 found, displaying 1 through 5" tabindex="0">7 found, displaying 1 through 5</span><br>' +
            '</span></div>';

        var bottomPanelExpectedHtml = '\n' +
                '\n' +
                '<div class="backgrid-paginator"><span>' +
                '<span aria-label="7 found, displaying 1 through 5" tabindex="0">7 found, displaying 1 through 5</span><br>' +
                '<ul>' +
                '<li class="disabled"><a href="javascript:void(0);" title="First" aria-label="Display first Page of appointments (Disabled)" tabindex="0">《</a></li>' +
                '<li class="disabled"><a href="javascript:void(0);" title="Previous" tabindex="0" aria-label="Display previous appointments (Disabled)">〈</a></li>' +
                '<li class="active"><a href="javascript:void(0);" title="Page 1" aria-label="Page 1, showing appointments 1 through 5" tabindex="0">1</a></li>' +
                '<li><a href="javascript:void(0);" title="Page 2" aria-label="Page 2, display appointments 6 through 7" tabindex="0">2</a></li>' +
                '<li><a href="javascript:void(0);" title="Next" tabindex="0" aria-label="Display next appointments, display appointments 6 through 7">〉</a></li>' +
                '<li><a href="javascript:void(0);" title="Last" aria-label="Display last page of appointments" tabindex="0">》</a></li>' +
                '</ul>' +
                '</span></div>';

        layout.render();

        beforeEach(function() {
            jasmine.addMatchers(customMatchers);
            view = new BookedAppointmentsView({ collection: appointmentList});
            layout.showChildView('content', view);
            $view = view.$el;
        });

        it('has top and bottom pagination panels', function() {

            expect($view.has(view.regions.paginationControlTopRegion).length).toEqual(1);
            expect($view.has(view.regions.paginationControlBottomRegion).length).toEqual(1);

            // top panel has only the page text..
            expect($view.find('#top-paginator').length).toEqual(1);
            expect($view.find('#top-paginator')[0].innerHTML.trim()).toEqual(topPanelExpectedHtml.trim());


            expect($view.find('#bottom-paginator-div').length).toEqual(1);
            expect(bottomPanelExpectedHtml.trim()).toEqual($view.find('#bottom-paginator-div')[0].innerHTML.trim());

        });
    });


}

);
